/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMAttachment;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.runtime.property.VWAttachmentsTableData;
import filenet.vw.toolkit.runtime.property.VWFieldsTableData;
import filenet.vw.toolkit.runtime.property.VWStepTableModelBase;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWAttachmentSelectionHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWFieldNameForTable;
import java.awt.Frame;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JOptionPane;

public class VWStepAttachmentsTableModel
extends VWStepTableModelBase {
    public static final int COL_EXPAND = 0;
    public static final int COL_NAME = 1;
    public static final int COL_VALUE = 2;
    public static final int COL_ACCESS_MODE = 3;
    private Frame m_parentFrame = null;
    private Vector m_dataFieldNames = new Vector();
    private Vector m_dataFieldMode = new Vector();

    public VWStepAttachmentsTableModel(Frame parentFrame) {
        this.m_parentFrame = parentFrame;
        this.m_type = new BitSet();
        this.m_type.set(32);
    }

    private int findDataFieldInList(String name) {
        int index = -1;
        for (int i = 0; i < this.m_dataFieldNames.size(); ++i) {
            if (VWStringUtils.compare(name, (String)this.m_dataFieldNames.elementAt(i)) != 0) continue;
            index = i;
            break;
        }
        return index;
    }

    protected VWFieldsTableData newDataFieldInstance(VWTrkTestDataField vwDataField) throws Exception {
        VWAttachmentsTableData datafield = new VWAttachmentsTableData(vwDataField);
        String name = vwDataField.getName();
        int index = this.findDataFieldInList(name);
        if (index == -1) {
            this.m_dataFieldNames.addElement(new String(vwDataField.getName()));
            this.m_dataFieldMode.addElement(new Boolean(false));
        } else {
            datafield.setExpanded((Boolean)this.m_dataFieldMode.elementAt(index));
        }
        return datafield;
    }

    protected void initColumnNames() {
        this.m_columnNames.addElement("");
        this.m_columnNames.addElement(VWResource.s_name);
        this.m_columnNames.addElement(VWResource.s_item);
    }

    public Object getValueAt(int row, int col) {
        if (!this.isInRange(row, col)) {
            return null;
        }
        boolean count = false;
        boolean bFound = false;
        int fieldIndex = -1;
        int rowIndex = -1;
        int[] index = new int[2];
        bFound = this.rowToFieldIndex(row, index);
        fieldIndex = index[0];
        rowIndex = index[1];
        if (bFound) {
            VWAttachmentsTableData dataField = (VWAttachmentsTableData)this.m_data.elementAt(fieldIndex);
            Object value = null;
            value = !dataField.isExpandable() ? dataField.getValue() : (dataField.isExpanded() ? dataField.getValue(rowIndex) : dataField.getValue());
            switch (col) {
                case 0: {
                    if (rowIndex == 0 && dataField.isExpandable()) {
                        return new Boolean(dataField.isExpanded());
                    }
                    return new String();
                }
                case 1: {
                    if (rowIndex == 0) {
                        return new VWFieldNameForTable(dataField.getName(), dataField.getDescription());
                    }
                    return null;
                }
                case 2: {
                    int type = dataField.getType();
                    boolean bArray = dataField.isArray();
                    if (dataField.isVariousValues()) {
                        return new VWFieldDataForTable(type, bArray, dataField.getValue(), dataField.getName());
                    }
                    if (!dataField.isExpandable()) {
                        return new VWFieldDataForTable(type, bArray, dataField.getValue(), dataField.getName());
                    }
                    if (dataField.isExpanded()) {
                        if (value == null) {
                            return new VWFieldDataForTable(type, bArray, new VWAttachment(), dataField.getName());
                        }
                        return new VWFieldDataForTable(type, bArray, dataField.getValue(rowIndex), dataField.getName());
                    }
                    if (rowIndex > 0) {
                        return null;
                    }
                    return new VWFieldDataForTable(type, bArray, dataField.getValue(), dataField.getName());
                }
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        if (!this.isInRange(row, col)) {
            return;
        }
        if (col != 2 && col != 0) {
            return;
        }
        boolean count = false;
        boolean bFound = false;
        int fieldIndex = -1;
        int rowIndex = -1;
        int[] index = new int[2];
        bFound = this.rowToFieldIndex(row, index);
        fieldIndex = index[0];
        rowIndex = index[1];
        if (bFound) {
            VWAttachmentsTableData dataField = (VWAttachmentsTableData)this.m_data.elementAt(fieldIndex);
            switch (col) {
                case 0: {
                    if (value == null || !(value instanceof Boolean) || dataField.isExpanded() == ((Boolean)value).booleanValue()) break;
                    dataField.setExpanded((Boolean)value);
                    this.fireTableDataChanged();
                    int indexInList = this.findDataFieldInList(dataField.getName());
                    if (indexInList == -1) break;
                    this.m_dataFieldMode.setElementAt(new Boolean(dataField.isExpanded()), indexInList);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    try {
                        if (!dataField.isExpandable()) {
                            dataField.setValue(value);
                        } else if (dataField.isExpanded()) {
                            dataField.setValue(value, rowIndex);
                        } else {
                            if (rowIndex != 0) break;
                            dataField.setValue(value);
                        }
                        if (!dataField.isExpandable() && dataField.isExpanded()) {
                            this.fireTableRowsUpdated(row, row + dataField.getSize());
                            break;
                        }
                        this.fireTableRowsUpdated(row, row);
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex, VWResource.s_settingFieldValue);
                    }
                    break;
                }
            }
        }
    }

    public Class getColumnClass(int col) {
        if (!this.isColInRange(col)) {
            return null;
        }
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return null;
    }

    private Object getValue(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        return this.getValueAt(row, 2);
    }

    public boolean getCanAssign(int row) {
        return this.isInRange(row, 2);
    }

    public boolean getCanUnassign(int row) {
        if (!this.isInRange(row, 2)) {
            return false;
        }
        Object value = this.getValue(row);
        if (value instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)value;
            if (data.isArray()) {
                return this.getCanDelete(row);
            }
            value = data.getValue();
        }
        return value != null && value instanceof VWAttachment && ((VWAttachment)value).getId() != null;
    }

    public boolean getCanViewAttachProp(int row) {
        if (!this.isInRange(row, 2)) {
            return false;
        }
        Object value = this.getValue(row);
        if (value instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)value;
            value = data.getValue();
        }
        if (value != null && value instanceof VWAttachment && ((VWAttachment)value).getId() != null) {
            return true;
        }
        return true;
    }

    public boolean getCanViewItemProp(int row) {
        if (!this.isInRange(row, 2)) {
            return false;
        }
        Object value = this.getValue(row);
        if (value instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)value;
            value = data.getValue();
        }
        if (value != null && value instanceof VWAttachment) {
            if (((VWAttachment)value).getType() == 5) {
                return false;
            }
            if (((VWAttachment)value).getId() != null) {
                return true;
            }
        }
        return false;
    }

    public boolean getCanOpen(int row) {
        if (!this.isInRange(row, 2)) {
            return false;
        }
        Object value = this.getValue(row);
        if (value instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)value;
            value = data.getValue();
        }
        return value != null && value instanceof VWAttachment && ((VWAttachment)value).getId() != null;
    }

    public boolean getCanAdd(int row) {
        if (!this.isInRange(row, 2)) {
            return false;
        }
        Object value = null;
        int[] index = new int[2];
        boolean bFound = this.rowToFieldIndex(row, index);
        int fieldIndex = index[0];
        int rowIndex = index[1];
        if (bFound) {
            VWAttachmentsTableData dataField = (VWAttachmentsTableData)this.m_data.elementAt(fieldIndex);
            return dataField.isArray();
        }
        return false;
    }

    public boolean getCanDelete(int row) {
        VWAttachmentsTableData dataField;
        if (!this.isInRange(row, 2)) {
            return false;
        }
        Object value = null;
        int[] index = new int[2];
        boolean bFound = this.rowToFieldIndex(row, index);
        int fieldIndex = index[0];
        int rowIndex = index[1];
        return bFound && (dataField = (VWAttachmentsTableData)this.m_data.elementAt(fieldIndex)) != null && dataField.isArray() && dataField.isExpanded() && rowIndex < dataField.getSize();
    }

    public String getDescription(int row, int col) {
        Object value;
        if (col == 1) {
            VWFieldsTableData datafield = this.getDataField(row);
            if (datafield != null) {
                return datafield.getDescription();
            }
        } else if (col == 2 && (value = this.getValue(row)) instanceof VWAttachment) {
            return ((VWAttachment)value).getAttachmentDescription();
        }
        return new String();
    }

    public boolean isCellEditable(int row, int col) {
        if (!this.isInRange(row, col)) {
            return false;
        }
        boolean bEditable = false;
        if (!this.m_bTableEditable && col != 0 && col != 2) {
            return false;
        }
        VWFieldsTableData dataField = null;
        int[] index = new int[2];
        boolean bFound = this.rowToFieldIndex(row, index);
        int fieldIndex = index[0];
        int rowIndex = index[1];
        if (!bFound) {
            return false;
        }
        dataField = (VWFieldsTableData)this.m_data.elementAt(fieldIndex);
        switch (col) {
            case 0: {
                return dataField.isArray();
            }
            case 2: {
                bEditable = dataField.isArray() ? (!dataField.isExpanded() ? true : !dataField.isVariousValues()) : true;
                return bEditable;
            }
        }
        return false;
    }

    public boolean isRemovableAttachment(int row) {
        if (!this.isInRange(row, 0)) {
            return false;
        }
        int[] index = new int[2];
        boolean bFound = this.rowToFieldIndex(row, index);
        int fieldIndex = index[0];
        int rowIndex = index[1];
        if (bFound) {
            VWAttachmentsTableData dataField = (VWAttachmentsTableData)this.m_data.elementAt(fieldIndex);
            return !dataField.isPreDefinedAttachment();
        }
        return false;
    }

    public void openAssignedAttachment(int row) throws VWException {
        VWAttachment attach;
        Object obj = this.getValue(row);
        if (obj instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)obj;
            obj = data.getValue();
        }
        if (obj != null && obj instanceof VWAttachment && (attach = (VWAttachment)obj) != null) {
            if (attach.getType() == 5) {
                try {
                    VWAttachmentSelectionHelper.openURL(attach.getId());
                }
                catch (Exception e) {
                    VWDebug.logException(e);
                    JOptionPane.showMessageDialog(this.m_parentFrame, e.getMessage(), VWResource.s_openAssignedItem, 0);
                }
            } else if (attach.getType() == 6) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_cannotOpenCustomObjectAttachment, VWResource.s_openAssignedItem, 0);
            } else {
                IVWIDMItem item = VWIDMBaseFactory.instance().getIDMItemFromVWAttachment((VWAttachment)obj);
                if (item != null) {
                    IVWIDMAttachment idmAttachment = item.getAttachment();
                    idmAttachment.open();
                }
            }
        }
    }

    public void assignedItemProperties(int row) throws VWException {
        IVWIDMItem item;
        Object obj = this.getValue(row);
        if (obj instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)obj;
            obj = data.getValue();
        }
        if (obj != null && obj instanceof VWAttachment && (item = VWIDMBaseFactory.instance().getIDMItemFromVWAttachment((VWAttachment)obj)) != null) {
            IVWIDMAttachment idmAttachment = item.getAttachment();
            idmAttachment.showPropertiesDialog();
        }
    }

    public void assignAttachment(int row) throws VWException {
        IVWIDMItem IIDMItem;
        VWAttachment newAttachment;
        Object obj = this.getValue(row);
        if (obj instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)obj;
            obj = data.getValue();
        }
        if (obj != null && obj instanceof VWAttachment && (newAttachment = VWAttachmentSelectionHelper.browseForAttachment(IIDMItem = null, VWResource.s_browse, this.m_parentFrame)) != null) {
            String description = ((VWAttachment)obj).getAttachmentDescription();
            if (description != null) {
                newAttachment.setAttachmentDescription(description);
            }
            this.setValueAt(newAttachment, row, 2);
            this.fireTableDataChanged();
        }
    }

    public void unassignAttachment(int row) throws VWException {
        Object obj = this.getValue(row);
        if (obj instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)obj;
            if (data.isArray()) {
                this.removeAttachment(row);
                return;
            }
            obj = data.getValue();
        }
        if (obj != null && obj instanceof VWAttachment) {
            this.setValueAt(new VWAttachment(), row, 2);
            this.fireTableDataChanged();
        }
    }

    public void removeAttachment(int row) {
        VWAttachmentsTableData dataField;
        if (!this.getCanDelete(row)) {
            return;
        }
        int[] index = new int[2];
        boolean bFound = this.rowToFieldIndex(row, index);
        int fieldIndex = index[0];
        int rowIndex = index[1];
        if (bFound && (dataField = (VWAttachmentsTableData)this.m_data.elementAt(fieldIndex)) != null && dataField.isArray() && dataField.isExpanded() && rowIndex < dataField.getSize() && dataField.removeAttachment(rowIndex)) {
            this.fireTableDataChanged();
        }
    }

    public int getRowCount() {
        int rowCount = super.getRowCount();
        return rowCount;
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_parentFrame = null;
        if (this.m_dataFieldNames != null) {
            this.m_dataFieldNames.removeAllElements();
            this.m_dataFieldNames = null;
        }
        if (this.m_dataFieldMode != null) {
            this.m_dataFieldMode.removeAllElements();
            this.m_dataFieldMode = null;
        }
    }
}

